<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ComponentProgram extends Model 
{

    protected $table = 'component_program';
    public $timestamps = true;
    protected $fillable = array('node_id', 'name', 'usage', 'shuffle');

    public function node()
    {
        return $this->belongsTo('App\Models\Node');
    }

    public function componentProgramItems()
    {
        return $this->hasMany('App\Models\ComponentProgramItem');
    }

    public function contentScheduledItems()
    {
        return $this->hasMany('App\Models\ContentScheduledItem');
    }

}